(function( $ ) {
	'use strict';
    
	$(document).ready(function() {
	    
	    $.ajax({
                url: REST_API_data.root + 'alfa-tools/v1/get_phone_link/',
                type: "POST",
                data: {
                   'nonce': REST_API_data.nonce,
                },
                scriptCharset: "utf-8",
                success: function (result) {
                    $('.phone-button .phone-button__number').html('<img alt="phone number" src="data:image/png;base64, '+ result.image +'">');
                },
    
            });
	    
        $('.phone-button').click(function(e) {
            e.preventDefault();
            $.ajax({
                url: REST_API_data.root + 'alfa-tools/v1/get_phone_link/',
                type: "POST",
                data: {
                   'nonce': REST_API_data.nonce 
                },
                scriptCharset: "utf-8",
                success: function (result) {
                    window.open(result.link, '_parent');
                },
    
            });
            return false;
        });
    });

})( jQuery );

document.addEventListener('DOMContentLoaded', function () {
  const waIcon = document.getElementById('custom-whatsapp-icon');
  if (!waIcon) return;

  // ---- helpers ----
  function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
    return null;
  }

  // Пытаемся достать clientId из _ga и sessionId из _ga_<MEASUREMENT_ID>
  function getAnalyticsIds() {
    let clientId = 'not_found';
    let sessionId = 'not_found';

    const rawGa = getCookie('_ga'); // формат обычно GA1.1.XXXXXXXXXX.YYYYYYYYY
    if (rawGa) {
      const parts = rawGa.split('.');
      if (parts.length >= 4) clientId = `${parts[2]}.${parts[3]}`;
    }

    // ищем cookie вида _ga_XXXX
    const cookieList = document.cookie.split(';').map(c => c.trim());
    const ga4Cookie = cookieList.find(c => /^_ga_[A-Z0-9]+=/.test(c));
    if (ga4Cookie) {
      const val = ga4Cookie.split('=')[1] || '';
      // Часто формат GS1.1.timestamp.sessionCount.sessionId
      const sp = val.split('.');
      if (sp.length >= 4) sessionId = sp[3];
    }

    return { clientId, sessionId };
  }

  function sanitizePhone(phone) {
    if (!phone) return '';
    return String(phone).replace(/[^\d]/g, ''); // только цифры
  }

  function buildWhatsAppUrl(phoneDigits, text, extraParams) {
    const base1 = 'https://wa.me/';                   // предпочтительный
    const base2 = 'https://api.whatsapp.com/send';    // fallback
    const query = new URLSearchParams({ text, ...extraParams }).toString();

    // Если номер есть — wa.me, иначе api.whatsapp без phone тоже откроет чат-подбор
    if (phoneDigits) {
      return {
        primary: `${base1}${phoneDigits}?${query}`,
        fallback: `${base2}?phone=${phoneDigits}&${query}`
      };
    }
    return {
      primary: `${base2}?${query}`,
      fallback: `${base2}?${query}`
    };
  }

  waIcon.addEventListener('click', function (e) {
    e.preventDefault();

    const rawPhone = this.dataset.phone || '';
    const phoneDigits = sanitizePhone(rawPhone);
    if (!phoneDigits) {
      console.warn('WhatsApp: пустой номер телефона в data-phone');
      return;
    }

    setTimeout(function () {
      const { clientId, sessionId } = getAnalyticsIds();
      const pageUrl = window.location.href;

      // 1) Человекочитаемое сообщение
      const humanReadableMessage = `Nachricht von der Website:\n${pageUrl}`;


      // 2) Технические данные (GA/UTM)
      const urlParams = new URLSearchParams(window.location.search);
      const techDataParts = [
        `ClientID: ${clientId}`,
        `SessionID: ${sessionId}`
      ];
      ['utm_source','utm_medium','utm_campaign','utm_term','utm_content'].forEach(k => {
        if (urlParams.has(k)) techDataParts.push(`${k}: ${urlParams.get(k)}`);
      });
      const technicalDataString = techDataParts.join(' | ');

      // 3) Кодируем только значения (URLSearchParams сам кодирует)
      const extraParams = {
        // ваш служебный параметр — WhatsApp его просто проигнорирует, но вы увидите его в реферере
        wz_source: technicalDataString
      };

      const { primary, fallback } = buildWhatsAppUrl(
        phoneDigits,
        humanReadableMessage,
        extraParams
      );

      console.log('WhatsApp Debug Info:', {
        humanMessage: humanReadableMessage,
        techDataForB24: technicalDataString,
        primary, fallback
      });

      const win = window.open(primary, '_blank', 'noopener,noreferrer');
      // если что-то пойдет не так — пробуем fallback
    }, 500);
  });
});
